@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('user.list_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="{{ route('user.index') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control" placeholder="Search"
												required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit">
													<i class="fas fa-search"></i>
												</button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th>{{ __('user.th_user') }}</th>
													<th>{{ __('user.th_name') }}</th>
													<th>{{ __('user.th_email') }}</th>
													<th>{{ __('user.th_role') }}</th>
													<th>{{ __('user.th_status') }}</th>
													<th class="nowrap">{{ __('user.th_created_at') }}</th>
													<th class="fixed-width-td">{{ __('user.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($users as $user)
												<tr>
													<td class="align-middle">
														<div class="img-circle elevation-2 profile-image"
															style="background-image: url(' {{ img_url($user->profile_picture) }} ');">
														</div>
													</td>
													<td class="align-middle nowrap">
														{{ $user->name }}
													</td>
													<td class="align-middle nowrap">
														{{ $user->email }}
													</td>
													<td class="align-middle nowrap">
														{{ user_role($user->roles->first()) }}
													</td>
													<td class="align-middle">
														{!! status_badge($user->status) !!}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($user->created_at) }}
													</td>
													<td>
														<div class="d-flex">
															<a href="{{ route('user.edit', $user->id) }}" type="button"
																class="btn btn-warning mr-2">
																<i class="fa fa-edit"></i>
															</a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="{{ route('user.destroy', $user->id) }}">
																{{ csrf_field() }}
																@method('DELETE')
																<button class="btn btn-danger">
																	<i class="fa fa-trash"></i>
																</button>
															</form>
														</div>
													</td>
												</tr>
												@endforeach
												@if(count($users) == 0)
												<tr>
													<td colspan="9">
														<p class="text-center mb-0">{{ __('user.no_record_found') }}</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $users->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection